IF EXISTS (SELECT * FROM SYS.OBJECTS WHERE	NAME = 'UFD_MONTAR_CFOP')
	DROP FUNCTION [dbo].[UFD_MONTAR_CFOP] 
GO 
--select * from UFD_MONTAR_CFOP(1,505,1,68,1475931,1,0,0) 
CREATE FUNCTION [dbo].[UFD_MONTAR_CFOP] (@CD_EMP INT, 
										 @CD_FILIAL INT, 
										 @CD_MOV_OP INT,			
										 @CD_TRIB   INT,
										 @CD_PESSOA INT,
										 @TP_TRANSA INT,
										 @TP_MOV INT,
										 @TIPO_OPERACAO INT)
RETURNS @UFD_RETURN TABLE(
	CD_NT_OP    INT,
	CD_NT_OP_FC VARCHAR(10),
	DS_NT_OP	varchar	(100))

	BEGIN
			DECLARE @DEST_ORIG INT
			DECLARE @FLAG_MOV_IMPORTACAO INT
			DECLARE @TRANSACAO_UF INT --Tipo transacao 0-Estadual / 1-InterEstadual / 2-Exterior
			DECLARE @CFOP VARCHAR (10)
			DECLARE @INSC_ESTADUAL AS VARCHAR(20)
			DECLARE @FLAG_CONTRIBUINTE INT
			DECLARE @TIPO_FILIAL INT
			DECLARE @UF_PESSOA AS VARCHAR(2)
			DECLARE @CONTRIBUINTE INT 

			SELECT
				@TIPO_FILIAL = TP_FILIAL
			FROM
				PRC_FILIAL
			WHERE
				CD_EMP    = @CD_EMP
				AND CD_FILIAL = @CD_FILIAL

			SET @TRANSACAO_UF=2
			
			IF @CD_MOV_OP<>0
			begin
				SELECT
					@TP_TRANSA = GLB_MOV_OP.TP_MOV_OP_TRANSA
					,@TP_MOV = GLB_MOV_OP.TP_MOV
					,@DEST_ORIG = GLB_MOV_OP.DEST_ORIG
					,@FLAG_MOV_IMPORTACAO = ISNULL(GLB_MOV_OP.FLAG_MOV_IMPORTACAO, 0)
				FROM
					GLB_MOV_OP
				WHERE
					GLB_MOV_OP.CD_MOV_OP   = @CD_MOV_OP
					AND GLB_MOV_OP.POSSUI_PROD = 0
			 end
			
			IF @CD_MOV_OP=0
			begin
				SET @DEST_ORIG = 0
				SET	@FLAG_MOV_IMPORTACAO = 0
			 end

			SET @UF_PESSOA= ISNULL((SELECT top 1 UF FROM V_GLB_PESSOA WHERE  CD_EMP  = @CD_EMP  AND CD_PESSOA = @CD_PESSOA AND DEST_ORIG = @DEST_ORIG),'')
					 
			IF @FLAG_MOV_IMPORTACAO = 0 --Nao e exterior
				BEGIN
						SET @TRANSACAO_UF=0 --Inicia como estadual 

						IF EXISTS (SELECT
												 CD_PESSOA
											 FROM
												 V_GLB_PESSOA
											 WHERE
														CD_EMP    = @CD_EMP
												AND CD_PESSOA = @CD_PESSOA
												AND DEST_ORIG = @DEST_ORIG
												AND UF        <> (SELECT top 1
																						UF
																					FROM
																						V_GLB_PESSOA
																					WHERE
																							 CD_EMP    = @CD_EMP
																					 AND CD_PESSOA = @CD_FILIAL
																					 AND DEST_ORIG = 2))--Pegando os dados da filial
							BEGIN
		 							
								SET @TRANSACAO_UF=1 --UF diferente entao e interEstadual
								
							END
				END

			--Operacao interna
			--mesmo sendo interEstadual		
			IF @TIPO_OPERACAO=1 
			BEGIN
				SET @TRANSACAO_UF=0
			END

		    IF @UF_PESSOA = 'EX' AND @TP_TRANSA = 1  AND @DEST_ORIG = 0
				BEGIN 
					SET @TRANSACAO_UF=0 
					--A NF-e emitida para turista estrangeiro no inscrito no Cadastro de Pessoa Fsica (CPF) deve seguir
                    -- a mesma forma adotada para a natureza da operao como se fosse destinada ao cidado brasileiro consumidor final.
				END

			SELECT
				@INSC_ESTADUAL = INSC_EST
				,@CONTRIBUINTE = CONTRIBUINTE
			FROM
				V_GLB_PESSOA
			WHERE
						CD_EMP    = @CD_EMP
				AND CD_PESSOA = @CD_PESSOA
				AND DEST_ORIG = @DEST_ORIG

			SET @FLAG_CONTRIBUINTE=0

			IF ((@INSC_ESTADUAL IN ( 'ISENTO', 'ISENTA' )) OR ( @CONTRIBUINTE = 9 ))
				BEGIN
						SET @FLAG_CONTRIBUINTE=1
				END


			IF @TP_MOV = 28  
			BEGIN   
				SET @TRANSACAO_UF  = 0
			END

			SELECT TOP 1
				@CFOP = CONVERT(CHAR(1), GLB_ORIG_DEST_NT_OP.CD_ORIG_DEST)
								+ '.'
			FROM
				GLB_ORIG_DEST_NT_OP
			WHERE
						GLB_ORIG_DEST_NT_OP.TP_TRANSA = @TP_TRANSA
				AND (GLB_ORIG_DEST_NT_OP.ORIG_DEST = @TRANSACAO_UF or GLB_ORIG_DEST_NT_OP.ORIG_DEST=3)
				AND GLB_ORIG_DEST_NT_OP.STS       = 0

			SELECT TOP 1
				@CFOP = @CFOP
								+ CONVERT(CHAR(4), GLB_NT_OP_PROD.NR_CFOP_PROD)
			FROM
				GLB_NT_OP_PROD
				INNER JOIN GLB_NT_OP_TRIB_PROD ON
					GLB_NT_OP_PROD.CD_NT_OP_PROD = GLB_NT_OP_TRIB_PROD.CD_NT_OP_PROD
			WHERE
						GLB_NT_OP_TRIB_PROD.CD_EMP          = @CD_EMP
				AND GLB_NT_OP_TRIB_PROD.CD_TRIB         = @CD_TRIB
				AND GLB_NT_OP_PROD.TP_MOV               = @TP_MOV
				AND (GLB_NT_OP_PROD.ORIG_DEST = @TRANSACAO_UF or GLB_NT_OP_PROD.ORIG_DEST=3)
				AND ( GLB_NT_OP_PROD.TP_MOV_OP_TRANSA     = 2
							 OR GLB_NT_OP_PROD.TP_MOV_OP_TRANSA     = @TP_TRANSA )
				AND ( GLB_NT_OP_PROD.TP_DEST_CONTRIBUINTE = 2
							 OR GLB_NT_OP_PROD.TP_DEST_CONTRIBUINTE = @FLAG_CONTRIBUINTE )
				AND GLB_NT_OP_PROD.STS                  = 0
				AND ( GLB_NT_OP_PROD.TP_EMP               = 2
							 OR GLB_NT_OP_PROD.TP_EMP               = @TIPO_FILIAL )

			INSERT INTO @UFD_RETURN
			SELECT TOP 1
				CD_NT_OP
				,CD_NT_OP_FC
				,DS_NT_OP	 
			FROM
				GLB_NT_OP
			WHERE
				CD_NT_OP_FC = @CFOP

			RETURN
	END 
